import Vue from 'vue'
import Router from 'vue-router'
// import 'vueConfig'
const login = resolve => require(['@/views/login'], resolve);
import nav1 from './nav1/index'
import nav2 from './nav2/index'
import nav3 from './nav3/index'
import charts from './charts/index'
const missing = resolve => require(['@/views/404'], resolve);
// const parent = resolve => require(['@/components/parent'], resolve);//子页面
const Home = resolve => require(['@/views/Home'], resolve);//子页面

Vue.use(Router);
const routes = [
	{// 404
		path: '*',
		component: missing
	},
	{
		path: '/login',
		component:login,
		name: '',
		hidden: true
	},
	// ...login,
	// 通用页面
	// {
	// 	path: '/',
	// 	redirect: '/login',
	// 	component: parent,
	// 	children: [].concat(login, UI),
	// 	beforeEnter: (to, from, next) => {
	// 		if ((localStorage.$getLocalStorageByName('user') || {}).personId) {
	// 			store.commit('goHome');
	// 			let home = store.state.navSide.homePage; //根据权限跳转至首页
	// 			next(home ? home : {'name': 'platformSetInfoManage'});
	// 		}else{
	// 			next();
	// 		}
	// 	},
	// },
	// 主页面
	{
		path: '/home',
		redirect: '/main/platformSet/infoManage',
		name: 'home',
		component: Home,
		children: [].concat(nav1,nav2,nav3,charts)
	},
].reverse();
export const router = new Router({
	routes,
	mode: 'history',
})
router.beforeEach((to, from, next) => {
  if (to.path == '/login') {
    sessionStorage.removeItem('user');
  }
  let user = JSON.parse(sessionStorage.getItem('user'));
  if (!user && to.path != '/login') {
    next({ path: '/login' })
  } else {
    next()
  }
})
// router.beforeEach(async (to,from,next)=>{
// 	document.body.scrollTop = 0;
// 	document.title = (typeof to.meta.title === 'function' ? to.meta.title(to) : to.meta.title) || '无标题';
// 	next();
// })
