
const Login = resolve => require(['@/views/Login'], resolve);
const NotFound = resolve => require(['@/views/404'], resolve);
const Home = resolve => require(['@/views/Home'], resolve);
const Main = resolve => require(['@/views/Main'], resolve);
const Table = resolve => require(['@/views/nav1/table'], resolve);
const Form = resolve => require(['@/views/nav1/form'], resolve);
const User = resolve => require(['@/views/nav1/user'], resolve);
const Increment = resolve => require(['@/views/nav2/increment'], resolve);
const Page5 = resolve => require(['@/views/nav3/page5'], resolve);
const Echarts = resolve => require(['@/views/charts/echarts'], resolve);
const Test = resolve => require(['@/views/nav1/test'], resolve);
import Vue from 'vue'
import Router from 'vue-router'
Vue.use(Router)
let routes = [
    {
        path: '/login',
        component: Login,
        name: '',
        hidden: true
    },
    {
        path: '/404',
        component: NotFound,
        name: '',
        hidden: true
    },
    //{ path: '/main', component: Main },
    {
				path: '/',
				redirect: '/404',
        component: Home,
        name: '导航一',
        iconCls: 'el-icon-message',//图标样式class
        children: [
            { path: '/main', component: Main, name: '主页', hidden: true },
						{ path: '/table', component: Table, name: 'Table',
							// children: [
							// 	{ path: '/test', component:Test,name: 'test'},
							// ]
						},
            { path: '/form', component: Form, name: 'Form' },
						{ path: '/user', component: User, name: '列表' },
						{ path: '/test', component: Test, name: 'Test',hidden:true},
        ]
    },
    {
        path: '/',
        component: Home,
        name: '导航二',
        iconCls: 'fa fa-id-card-o',
        children: [
            { path: '/increment', component: Increment, name: 'increment' },
        ]
    },
    {
        path: '/',
        component: Home,
        name: '',
        iconCls: 'fa fa-address-card',
        leaf: true,//只有一个节点
        children: [
            { path: '/page5', component: Page5, name: '导航三' }
        ]
    },
    {
        path: '/',
        component: Home,
        name: 'Charts',
        iconCls: 'fa fa-bar-chart',
        children: [
            { path: '/echarts', component: Echarts, name: 'echarts' }
        ]
    },
    {
        path: '*',
        hidden: true,
        redirect: { path: '/404' }
    }
];
export const router = new Router({
	routes,
	mode: 'history',
})
router.beforeEach((to, from, next) => {
	//NProgress.start();
  if (to.path == '/login') {
    sessionStorage.removeItem('user');
  }
  let user = JSON.parse(sessionStorage.getItem('user'));
  if (!user && to.path != '/login') {
    next({ path: '/login' })
  } else {
    next()
  }
})
// export default routes;