
import product from './product/index'
import order from './order/index'
import logistics from './logistics/index'
import selectionProduct from './selectionProduct/index'
const login = resolve => require(['@/views/Login'], resolve);
const missing = resolve => require(['@/views/404'], resolve);
const Home = resolve => require(['@/views/Home'], resolve);//子页面


Vue.use(VueRouter);
const routes = [
	{// 404
		path: '*',
		component: login
	},
	{
		path: '/login',
		component:login,
		name: '',
		hidden: true
	},
	// ...login,
	// 通用页面
	// {
	// 	path: '/',
	// 	redirect: '/login',
	// 	component: parent,
	// 	children: [].concat(login, UI),
	// 	beforeEnter: (to, from, next) => {
	// 		if ((localStorage.$getLocalStorageByName('user') || {}).personId) {
	// 			store.commit('goHome');
	// 			let home = store.state.navSide.homePage; //根据权限跳转至首页
	// 			next(home ? home : {'name': 'platformSetInfoManage'});
	// 		}else{
	// 			next();
	// 		}
	// 	},
	// },
	// 主页面
	{
		path: '/home',
		// redirect: '/',
		name: 'home',
		component: Home,
		children: [].concat(product,order,logistics,selectionProduct)
	},
].reverse();
export const router = new VueRouter({
	routes,
	mode: 'history',
})
router.beforeEach((to, from, next) => {
  if (to.path == '/login') {
    localStorage.removeItem('user');
	}
  let user = JSON.parse(localStorage.getItem('user'));
	if (!user && to.path != '/login') {
		next({ path: '/login' })
	}else {
		next()
	}
})
